import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Scanner;


public class RedZadaci {
	
	// U ovom fajlu su implementirani zadaci za cije rjesavanje je najbolje koristiti strukturu red.

	
	/*
	 * U tzv. "igri pijanih karti" spil karata se podijeli na dvije jednake gomile, svakom igracu po jedna. 
	 * Svaki od njih pokazuje po jednu kartu sa vrha spila i onaj cija je karta veca uzima karte i stavlja ih na dno svoje gomile. 
	 * Onaj koji ostane bez karata gubi igru. Da bi uprostili igru, smatracemo da sve karte imaju razlicite vrjednosti i da najmanja karta pobjedjuje najvecu. 
	 * Igrac koji nosi karte, na dno svoje gomile prvo stavlja svoju kartu a zatim kartu protivnika (tj. karta protivnika je uvijek na dnu gomile). 
	 * Napisite program koji modelira igru i stampa ko pobjedjuje i u koliko poteza. U igri ucestvuje 10 karata numerisanih od 0 do 9, veca karta "nosi" manju i karta 0 "nosi" kartu 9. 
	 * 		Ulaz: U prvom redu je 5 brojeva razdvojenih blankom  karte prvog igraca. U drugom redu je 5 brojeva razdvojenih blankom  karte drugog igraca. 
	 * 			  Karte su nabrojane od vrha prema dnu tj. igra pocinje sa prvom kartom. 
	 * 		Izlaz: U prvi i jedini red treba stampati rijec "first", ako pobjedjuje prvi igrac ili "second" ako pobjedjuje drugi igrac.
	 * 			   Zatim stampati jedan blanko i cio broj koji oznacava broj poteza do pobjede.
	 * 			   Ako se igra ne zavrsi za 10^6 poteza, stampati "draw".
	 * 		Primjer:
	 * 			Ulaz: 1 3 5 7 9
	 * 				  2 4 6 8 0 
	 * 			Izlaz: second 5
	 * */
	
	public static void karte(){
		// Ovaj zadatak rijesicemo simulacijom opisane igre. Dva spila implementiracemo kao redove, jer se karte uzimaju sa jednog kraja (vrha) spila, a dodaju na drugi kraj (dno).
		
		Queue<Integer> spil1 = new LinkedList<Integer>();
		Queue<Integer> spil2 = new LinkedList<Integer>();
		/* Obratite paznju na to da je Queue interfejs (red je apstraktna struktura podataka) i ne moze se instancirati.
		 * Red moze biti implementiran na dva nacina:
		 * 		1. kao ulancana lista
		 * 		2. kao kruzni bafer (niz)
		 */
		Scanner unos = new Scanner(System.in);
		for(int i = 0; i < 5; i++){
			spil1.add(unos.nextInt()); // funkcija add() dodaje novi element na kraj reda
		}
		
		for(int i = 0; i < 5; i++){
			spil2.add(unos.nextInt());
		}
		
		int broj_poteza = 0;
		
		while(broj_poteza < 1000000){
			if(spil1.isEmpty()){
				System.out.println("second "+Integer.toString(broj_poteza));
				return;
			}else if(spil2.isEmpty()){
				System.out.println("first "+Integer.toString(broj_poteza));
				return;
			}else{
				int karta1 = spil1.poll(); // funkcija poll() brise i vraca element sa pocetka reda
				int karta2 = spil2.poll();
				
				if(veca(karta1, karta2)){
					// smjesta prvo svoju kartu, pa kartu protivnika
					spil1.add(karta1);
					spil1.add(karta2);
				}else{
					spil2.add(karta2);
					spil2.add(karta1);
				}
			}
			
			broj_poteza++;
		}
		
		System.out.println("draw");
	}
	
	public static boolean veca(int karta1, int karta2){
		// funkcija vraca true ako je karta1 veca od karte2, a false u suprotnom
		if(karta1==9 && karta2==0)
			return false;
		else if(karta1==0 && karta2==9)
			return true;
		else if(karta1>karta2)
			return true;
		
		return false;
		
	}
	
	// Napisati funkciju koja racuna koliko je najmanje poteza potrebno skakacu da dodje sa jednog na drugo polje sahovske table.
	// Za vjezbu: Odstampati poteze koji vode skakaca sa startnog do krajnjeg polja.
	public static int skakac(String startPos, String endPos)
	{
		/* Ideja je da se REDOM obilaze polja koja su udaljena od pocetnog 0 poteza, pa zatim polja koja su udaljena 1 potez, pa polja koja su udaljena 2 poteza itd.
		 * Na ovaj nacin cemo sigurno do krajnjeg polja doci u minimalnom broju poteza.
		 * Opisani algoritam se zove Breadth First Search (BFS) tj. pretrazivanje u sirinu.
		 */
		boolean[][] visited = new boolean[9][9];  // vodimo evidenciju koja smo polja posjetili da se ne bi vracali na njih
		int cnt = 0; // brojac broja poteza
		
		int sx, sy, ex, ey; // pozicija polja
		// konverzija stringa u poziciju
		sx = startPos.charAt(0) - 'A' + 1;
		sy = startPos.charAt(1) - '0';
		ex = endPos.charAt(0) - 'A' + 1;
		ey = endPos.charAt(1) - '0';
		
		// System.out.printf("%d %d %d %d\n", sx,sy, ex, ey);
		
		Queue<Trojka> q =  new LinkedList<Trojka>(); // red za smjestanje poteza
		
		visited[sx][sy] = true;
		q.add(new Trojka(sx,sy,0));
		int currX, currY;
		
		int[][] d = {{1,-2}, {1,2},{-1,-2}, {-1,2},{2,-1}, {2,1}, {-2,-1}, {-2,1}}; // moguci potezi skakaca sa tekuce pozicije
		while (true)
		{
			Trojka t = q.remove();
			if((t.x == ex) && (t.y == ey))
				return t.cnt;
			// Pokusavamo sve moguce poteze iz trenutnog polja
			for (int i = 0; i < d.length; i++) 
			{
				currX = t.x + d[i][0];
				currY = t.y + d[i][1];
				if (currX > 0 && currX < 9 && currY > 0 && currY < 9 && visited[currX][currY] == false)
				{
					// ako smo u granicama sahovske table i dato polje nijesmo ranije posjetili, dodajemo ga u red za obilazak
					q.add(new Trojka(currX, currY, t.cnt+1)); // broj poteza do tog polja je za 1 veci od trenutnog
					visited[currX][currY] = true; // oznacimo polje kao posjeceno
				}
			}
		}
	}
	
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub		
		System.out.println(skakac("A1", "D5"));
		karte();
	}

}
